import {
    DimensionTypes,
    ItemStack,
    system,
    World,
    world
} from "@minecraft/server"



world.afterEvents.itemUse.subscribe(event => {
    const player = event.source
    const item = event.itemStack
    const dimension = player.dimension
    if (item.typeId == "minecraft:stick") {
        const entity = dimension.spawnEntity("test:test", player.location)
        player.sendMessage("Spawned test entity")
        system.runTimeout(() => {
            entity.triggerEvent("small_hit_box")
            player.sendMessage("Ran small hit box event")
        }, 40)
    }
})
world.beforeEvents.playerInteractWithEntity.subscribe(event => {
    const player = event.player
    const entity = event.target
    if (entity.typeId== "test:test") {
        player.sendMessage("Interacted with test entity")
    }
})
world.afterEvents.playerJoin.subscribe(event => {
    const playerId = event.playerId
    const player = world.getEntity(playerId)
    player.getComponent("inventory").container.addItem(new ItemStack("minecraft:stick", 1))
})